#! /bin/sh
psql=/usr/pgsql-18/bin/psql
DATADIR_BASE=/var/volum/RockyLinux9/18/V4_2_STABLE/src/test/regression/tests/071.execute_and_deallocate/testdir
PGSUPERUSER=postgres
export PGHOST=/var/run/postgresql
main_db_cluster=$1
recovery_node_host_name=$2
DEST_CLUSTER=$3
PORT=$4

log=$DATADIR_BASE/log/recovery.log

$psql -p $PORT -c "SELECT pg_start_backup('Native Replication', true)" postgres

echo "source: $main_db_cluster dest: $DEST_CLUSTER" > $log
cat > $main_db_cluster/myrecovery.conf <<REOF
restore_command = 'cp /var/volum/RockyLinux9/18/V4_2_STABLE/src/test/regression/tests/071.execute_and_deallocate/testdir/archivedir/`basename $1`/%f %p'
REOF
rsync -C -a -c --delete --exclude postgresql.conf --exclude postmaster.pid \
--exclude postmaster.opts --exclude pg_log \
--exclude recovery.done \
--exclude pg_xlog pg_wal \
$main_db_cluster/ $DEST_CLUSTER/

rm -fr $DEST_CLUSTER/pg_xlog 
mkdir $DEST_CLUSTER/pg_xlog
chmod 700 $DEST_CLUSTER/pg_xlog

rm -fr $DEST_CLUSTER/pg_wal
mkdir $DEST_CLUSTER/pg_wal
chmod 700 $DEST_CLUSTER/pg_wal
$psql -p $PORT -c "SELECT pg_stop_backup()" postgres
touch $DEST_CLUSTER/recovery.signal
