#! /bin/sh
psql=/usr/pgsql-18/bin/psql
pg_rewind=/usr/pgsql-18/bin/pg_rewind
pg_basebackup=/usr/pgsql-18/bin/pg_basebackup
PG_CTL=/usr/pgsql-18/bin/pg_ctl
DATADIR_BASE=/var/volum/RockyLinux9/18/V4_2_STABLE/src/test/regression/tests/017.node_0_is_down/testdir
PGSUPERUSER=postgres

main_db_cluster=$1
recovery_node_host_name=$2
DEST_CLUSTER=$3
PORT=$4
recovery_node=$5

pg_rewind_failed="true"

log=$DATADIR_BASE/log/recovery.log
echo >> $log
date >> $log

echo "export PGHOST=localhost" >> $1/$SCRIPT

# Make backup copy of postgresql.conf since pg_rewind/pg_basebackup blindly copies
# $main_db_cluster/postgresql.conf.
cp $DEST_CLUSTER/postgresql.conf /tmp/

pg_rewind_failed="true"
export PGHOST=localhost
if [ $pg_rewind_failed = "true" ];then

echo "source: $main_db_cluster dest: $DEST_CLUSTER" >> $log

rm -fr $DEST_CLUSTER/*
test -d $DEST_CLUSTER || mkdir $DEST_CLUSTER

$pg_basebackup -w -U $PGSUPERUSER -p $PORT -D $DEST_CLUSTER -c fast

fi
$psql -p $PORT -c "SELECT * FROM pg_create_physical_replication_slot('pgpool_setup_slot$recovery_node')" postgres
cat > $DEST_CLUSTER/myrecovery.conf <<REOF
primary_conninfo      = 'host=localhost port=$PORT user=$PGSUPERUSER application_name=''server$recovery_node'''
recovery_target_timeline='latest'
primary_slot_name = 'pgpool_setup_slot$recovery_node'
REOF
cp /tmp/postgresql.conf $DEST_CLUSTER/
touch $DEST_CLUSTER/standby.signal
