#! /bin/sh
# Execute command by failover.
# special values:  %d = node id
#                  %h = host name
#                  %p = port number
#                  %D = database cluster path
#                  %m = new primary node id
#                  %M = old main node id
#                  %H = new primary node host name
#                  %P = old primary node id
#                  %R = new primary database cluster path
#                  %r = new primary port number
#                  %N = old primary node host name
#                  %S = old primary node port number
#                  %% = '%' character
node_id=$1
host_name=$2
port=$3
db_cluster=$4
new_primary_id=$5
new_primary_host_name=$6
old_main_id=$7
old_primary_node_id=$8
new_primary_port_number=$9
new_primary_db_cluster=${10}
mydir=/var/volum/RockyLinux8/15/V4_3_STABLE/src/test/regression/tests/028.watchdog_enable_consensus_with_half_votes/testdir/pgpool2
log=$mydir/log/failover.log
pg_ctl=/usr/pgsql-15/bin/pg_ctl
PCP_PORT=50009
pgversion=150
export PCPPASSFILE=/var/volum/RockyLinux8/15/V4_3_STABLE/src/test/regression/tests/028.watchdog_enable_consensus_with_half_votes/testdir/pgpool2/pcppass
PGPOOL_BIN=/var/volum/RockyLinux8/15/V4_3_STABLE/src/test/regression/temp/installed/bin

echo "follow primary script started for node: $node_id" >> $log
date >> $log
echo "node_id: $node_id host_name: $host_name port: $port db_cluster: $db_cluster" >> $log
echo "new_primary_id: $new_primary_id old_main_id: $old_main_id new_main_host_name: $new_main_host_name" >> $log
echo "old_primary_node_id: $old_primary_node_id: new_primary_port_number: $new_primary_port_number new_primary_db_cluster: $new_primary_db_cluster" >> $log

# Skip the target standby node if it's not running
$pg_ctl -D $db_cluster status >/dev/null 2>&1
if [ $? = 0 ]
then
    # change primary node connection info so that it points to the new primary
    if [ $pgversion -ge 120 ];then
        sed -i "s/port=[0-9]*/port=$new_primary_port_number/" $db_cluster/myrecovery.conf
        sed -i "/restore_command/s/data[0-9]/`basename $new_primary_db_cluster`/" $db_cluster/myrecovery.conf
    else
	# if recovery.conf is not found, rename recovery.done.
	if [ ! -f $db_cluster/recovery.conf ];then
	   mv $db_cluster/recovery.done $db_cluster/recovery.conf
	fi
        sed -i "s/port=[0-9]*/port=$new_primary_port_number/" $db_cluster/recovery.conf
        sed -i "/restore_command/s/data[0-9]/`basename $new_primary_db_cluster`/" $db_cluster/recovery.conf
    fi

    touch $db_cluster/standby.signal

    echo "restart the target server" >> $log
    $pg_ctl -w -m f -D $db_cluster restart >> $log 2>&1

    $pg_ctl -D $db_cluster status >>$log 2>&1
    if [ $? != 0 ]
    then
        echo "restarting $db_cluster failed" >>$log
        echo "fallback to pcp_recovery_node" >>$log
        $PGPOOL_BIN/pcp_recovery_node -w -h localhost -p $PCP_PORT -n $node_id >> $log 2>&1
    else
        # attach the node
        $PGPOOL_BIN/pcp_attach_node -w -h localhost -p $PCP_PORT -n $node_id >> $log 2>&1
    fi
else
    echo "$db_cluster is not running. skipping follow primary command." >> $log
fi
echo "follow primary script ended." >> $log
date >> $log
